<?php

$this->pageTitle = 'Szczegóły szkolenia '.$model->nazwa.' - '.Yii::app()->name;

$this->breadcrumbs = array(
	'Szkolenia'=>array('admin'),
	'Szczegóły szkolenia '.$model->nazwa,
);

?>
<h1>Szczegóły szkolenia <?php echo $model->nazwa; ?></h1>

<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('update', array('id'=>$model->id)); ?>">Aktualizuj</a>

<?php

$this->widget('zii.widgets.CDetailView', array(
	'data'=>$model,
	'attributes'=>array(
		'id',
		'nazwa',
		array(
			'name' => 'idDziedzina',
			'value' => $model->dziedzina->nazwa
		),
		array(
			'name' => 'poziom',
			'value' => $model->poziomStr
		),
		array(
			'name' => 'czyEgzamin',
			'value' => $model->czyEgzamin ? 'Tak' : 'Nie'
		),
		array(
			'name' => 'czasTrwania',
			'value' => sprintf('%02d:%02d:%02d', (int)$model->czasTrwania / 3600, (int)$model->czasTrwania / 60, (int)$model->czasTrwania % 60)
		),
		array(
			'name' => 'cena',
			'value' => number_format($model->cena, 2, ',', ' ')
		),
		array(
			'name' => 'tresc',
			'type' => 'raw'
		),
	),
));

?>
